 <?php
   
  if (!empty($_POST['website'])) { exit('OK'); }

  function sanitize($key){ return htmlspecialchars(trim($_POST[$key] ?? ''), ENT_QUOTES, 'UTF-8'); }

  $name    = sanitize('name');
  $email   = sanitize('email');
  $phone   = sanitize('phone');
  $type    = sanitize('type');
  $message = sanitize('message');

  if(!$name || !$email || !$message){ http_response_code(400); echo "Missing required fields"; exit; }

  $to      = 'info@codersfly.com';
  $subject = 'New Inquiry — CodersFly Website';
  $body    = "Name: $name
Email: $email
Phone: $phone
Project Type: $type

Message:
$message
";
  $headers = "From: CodersFly Web <no-reply@".$_SERVER['SERVER_NAME'].">
Reply-To: $name <$email>
";

  if(mail($to, $subject, $body, $headers)){
    // Redirect back to the site (optional)
    header('Location: index.html#contact');
    echo 'Thanks! We\'ll be in touch.';
  } else {
    http_response_code(500);
    echo 'Failed to send email. Please try again later.';
  }
  ?>
  